/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.AutoUpdateGUI;
import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.HELP88XIPAddress;
import com.quantumdata.autoupdate.UpgradeScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IPAddrScreen
extends UpgradeScreen {
    private final String btnCancelCmd = "CANCEL";
    private final String btnEthernetCmd = "ETHERNET";
    private final String btnHelpCmd = "HELP";
    private final String btnBackCmd = "BACK";
    private JTextField m_txtIPAddr;

    public IPAddrScreen(String string, AutoUpdateGUI autoUpdateGUI) {
        super(string, autoUpdateGUI);
        this.configureJFrame(autoUpdateGUI);
    }

    protected void finalize() {
        System.out.println("Destroying IP Address Window");
        super.finalize();
        this.m_txtIPAddr = null;
    }

    private void configureJFrame(ActionListener actionListener) {
        Container container = super.getJFrame().getContentPane();
        JLabel jLabel = new JLabel("Please Enter the IP address of the 88X Generator you wish to Upgrade.");
        JLabel jLabel2 = new JLabel("IP Address:");
        this.m_txtIPAddr = new JTextField(15);
        this.m_txtIPAddr.setToolTipText("Enter The 88X Generator's IP Address");
        this.m_txtIPAddr.setText("000.000.000.000");
        jLabel2.setLabelFor(this.m_txtIPAddr);
        this.m_txtIPAddr.addFocusListener(this);
        this.m_txtIPAddr.setInputVerifier(new IPAddrVerifier(super.getJFrame()));
        this.m_txtIPAddr.requestFocusInWindow();
        JButton jButton = new JButton("Cancel");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('C');
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(actionListener);
        JButton jButton2 = new JButton("<< Back");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('B');
        jButton2.setDefaultCapable(true);
        jButton2.setActionCommand("BACK");
        jButton2.addActionListener(actionListener);
        JButton jButton3 = new JButton("Next >>");
        jButton3.setVerticalTextPosition(0);
        jButton3.setHorizontalTextPosition(10);
        jButton3.setMnemonic('N');
        jButton3.setDefaultCapable(true);
        jButton3.setActionCommand("ETHERNET");
        jButton3.addActionListener(actionListener);
        JButton jButton4 = new JButton("How to find the 88X Generator's IP address");
        jButton4.setVerticalTextPosition(0);
        jButton4.setHorizontalTextPosition(10);
        jButton4.setMnemonic('H');
        jButton4.setDefaultCapable(true);
        jButton4.setActionCommand("HELP");
        jButton4.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n = 6;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        int n2 = 70;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, n2, n, 4);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 2, n, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtIPAddr, gridBagConstraints);
        jPanel.add(this.m_txtIPAddr);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(jButton4, gridBagConstraints);
        jPanel.add(jButton4);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        JPanel jPanel3 = new JPanel();
        super.setLogo(jPanel3);
        container.add((Component)jPanel3, "First");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "Last");
        container.validate();
    }

    public String getIPAddress() {
        return this.m_txtIPAddr.getText();
    }

    public void setIPAddress(String string) {
        this.m_txtIPAddr.setText(string);
    }

    public int ScreenHandler(ActionEvent actionEvent, int n, Device88X device88X) {
        int n2 = n;
        int n3 = 0;
        if ("CANCEL".equals(actionEvent.getActionCommand())) {
            System.out.println("Exiting");
            System.exit(0);
        } else if ("HELP".equals(actionEvent.getActionCommand())) {
            HELP88XIPAddress hELP88XIPAddress = new HELP88XIPAddress();
            hELP88XIPAddress.pack();
            hELP88XIPAddress.setVisible(true);
        } else if ("BACK".equalsIgnoreCase(actionEvent.getActionCommand())) {
            n2 = -1;
        } else {
            do {
                device88X.setIPAddress(this.getIPAddress());
                System.out.println("IP=" + device88X.getIPAddress() + " Subnet=" + device88X.getSubnetMask() + " Gateway=" + device88X.getGatewayIP());
                if (device88X.IsDeviceThere(super.getJFrame())) {
                    n2 = 3;
                    n3 = -2;
                    continue;
                }
                Object[] objectArray = new Object[]{"Retry", "Enter a New IP Address", "Cancel Upgrade"};
                n3 = JOptionPane.showOptionDialog(super.getJFrame(), "Could not find " + device88X.getIPAddress(), "Host Not Found", 1, 2, null, objectArray, objectArray[0]);
            } while (n3 == 0);
            if (n3 == -1 || n3 == 1) {
                n2 = 2;
            } else if (n3 == 2) {
                System.out.println("Exiting");
                System.exit(0);
            }
            System.out.println("Next Screen " + n2);
        }
        return n2;
    }

    class IPAddrVerifier
    extends InputVerifier {
        JFrame m_JFrame;

        public IPAddrVerifier(JFrame jFrame) {
            this.m_JFrame = jFrame;
        }

        public boolean verify(JComponent jComponent) {
            JTextField jTextField = (JTextField)jComponent;
            if (jTextField.getText().matches("^\\d{1,3}[.]\\d{1,3}[.]\\d{1,3}[.]\\d{1,3}")) {
                return true;
            }
            JOptionPane.showMessageDialog(this.m_JFrame, "Invalid IP Address Format\nIP Addresses must be entered in the form of ###.###.###.###\nWhere # is a number between 0-9.", "Improper IP Address", 1);
            return false;
        }
    }
}

